﻿using System;
using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VRM.Integration.Servicebus.Core;
using VA.TMP.Integration.VIMT.Shared;

namespace VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.MakeCancel
{
    /// <summary>
    /// Connect to CRM step.
    /// </summary>
    public class ConnectToCrmStep : FilterBase<MakeCancelStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(MakeCancelStateObject state)
        {
            try
            {
                state.OrganizationServiceProxy = PipelineUtilities.ConnectToCrm(state.RequestMessage.OrganizationName, PipelineUtilities.CrmAuthenticationMode.Ad);
            }
            catch (Exception ex)
            {
                throw new Exception(string.Format("HealthShare Make Cancel ConnectToCrmStep Pipeline Error: {0}", ex.Message), ex.InnerException);
            }
        }
    }
}